# Econometrics. Ekonometria. Advances in Applied Data Analysis template

This template provides guidelines for authors submitting their work for _Econometrics_. Start with the title, abstract and keywords, then type the main text of your submission starting with _Introduction_, ending with _Discussion and Conclusions_.

This LaTeX template aims to give output visually as close as possible to the journal's other (DOCX) template. It is based on the _article_ class, but has significant modifications.

If you encounter any issues when using this template, please email the journal's [Support Contact](https://journals.ue.wroc.pl/eada/about/contact).

## Bibliography

To ensure all references are in APA 7th Edition style, according to our publisher's guidelines, this template uses `biber` and `biblatex` to compose reference list and citations. In-text citations should be made using the `\citep` macro, and all references (including those not cited directly) must be included in the `references.bib` file in BiBTeX format.

## Building

### CLI (MikTeX, TeXLive, MacTex, etc.) [Recommended]

For correct Unicode and fonts support, this template should be built using the XeTeX engine. Any missing packages are available on [CTAN](https://ctan.org).

First, run `xelatex` to generate the bibliographic information for `biber` to use. Make sure `references.bib` is in the same directory as you submission file.

```
xelatex eada_template.tex
```

Next, run biber to incorporate the bibliography information into your paper. Note the file extension omission.

```
biber eada_template
```

Finally, run `xelatex` again to build the complete PDF.

```
xelatex eada_template.tex
```

You may need to install biber separately. Windows users should be able to download it from the [project's website](https://biblatex-biber.sourceforge.net), macOS users can install it using the [Homebrew](https://brew.sh) package manager, and GNU/Linux users should be able to build it from [the source](https://github.com/plk/biber). This template has been tested with biber version 2.20.

### TeXStudio

1. From the main application menu, select `Tools -> Commands -> XeLaTeX`.
2. From the same menu, `Tools -> Commands -> Biber`.
3. Finally, `Tools -> Commands -> XeLaTeX` again.

### Overleaf

1. Start a new Overleaf project, by selecting `New Project -> Upload Project`
2. upload a template ZIP archive you downloaded from the journal's website.
3. To export, click the download PDF file button above the compiled view on the right-hand side.
